globals
[
  max-grain    ; maximln mnostv zrn, kter me na polkch vyrst
]

patches-own
[
  grain-here      ; aktuln mnostv zrn na tomto polku
  max-grain-here  ; maximln mnostv zrn pro dan polko
]

turtles-own
[
  age              ; st elvy
  wealth           ; mnostv zrn, kter elva vlastn
  life-expectancy  ; maximln vk, kterho se me elva dot
  metabolism       ; kolik zrn sn elva v kadm kole
  vision           ; kolik polek ped sebe elva dohldne
]

;;;
;;; Procedury tlatka Piprav
;;;

to setup
  ca
  ;; nastav globln promnn na pslun hodnoty
  set max-grain 50
  ;; spout ostatn procedury k pprav rznch st modelu
  setup-patches
  setup-turtles
  setup-plots
  ;; vynese do grafu vchoz situaci v modelu
  update-plots
end

;; nastav vchoz mnostv zrn pro vechna polka
to setup-patches
  ;; nkterm polkm je piazen nejvy mon poet zrn 
  ;; tato polka reprezentuj nejvnosnj pole
  ask patches
    [ set max-grain-here 0
      if (random-float 100.0) <= procento-nejlepsi-pudy
        [ set max-grain-here max-grain
          set grain-here max-grain-here ] ]
  ;; rozproste zrn po celm svt a pid vce 
  ;; ve prospch nejvnosnjm polm
  repeat 5
    [ ask patches with [max-grain-here != 0]
        [ set grain-here max-grain-here ]
      diffuse grain-here 0.25 ]
  repeat 10
    [ diffuse grain-here 0.25 ]          ;; rozptl zrn po okol o nco vce
  ask patches
    [ set grain-here floor grain-here    ;; zaokrouhl mnostv zrn na cel sla
      set max-grain-here grain-here      ;; vchoz mnostv zrn je zrove maximem
      recolor-patch ]
end

to recolor-patch  ;; procedura polek -- vyuv klu barev k vyjden mnostv zrn na polkch (hodnoty polek)
  set pcolor scale-color yellow grain-here 0 max-grain
end

;; piprav vchoz hodnoty pro promnn elv
to setup-turtles
  set-default-shape turtles "person"
  crt pocet-lidi
    [ move-to one-of patches  ;; umst elvy do sted polk
      set size 1.5  ;; pro sna viditelnost
      set-initial-turtle-vars
      set age random life-expectancy ]
  recolor-turtles
end

to set-initial-turtle-vars
  set age 0
  face one-of neighbors4
  set life-expectancy delka-zivota-min +
                        random (delka-zivota-max - delka-zivota-min + 1)
  set metabolism 1 + random metabolismus-max
  set wealth metabolism + random 50
  set vision 1 + random max-videni
end

;; Nastav elvm tdu podle bohatstv -- pokud m elva mn ne tetinu
;; majetku nejbohat elvy, pak je erven. Pokud vlastn mezi jednou a 
;; dvma tetinami tohoto majetku, pak je zelen. Nejbohat elvy jsou modr.
to recolor-turtles
  let max-wealth max [wealth] of turtles
  ask turtles
    [ ifelse (wealth <= max-wealth / 3)
        [ set color red ]
        [ ifelse (wealth <= (max-wealth * 2 / 3))
            [ set color green ]
            [ set color blue ] ] ]
end

;;;
;;; Procedury tlatka Start
;;;

to go
  ask turtles
    [ turn-towards-grain ]  ;; elva se oto smrem, kde je v rmci jejho dohledu nejvce zrn
  harvest
  ask turtles
    [ move-eat-age-die ]
  recolor-turtles

  ;; umouje rst zrn v prbhu asu
  if ticks mod interval-rustu-zrni = 0
    [ ask patches [ grow-grain ] ]

  tick
  update-plots
end

;; procedura urujc smr, kter je nejvnosnj pro kadou elvu z hlediska
;; mnostv zrn na okolnch polkch (v zvislosti na tom, jak daleko elva vid)
to turn-towards-grain  ;; procedura elv
  set heading 0
  let best-direction 0
  let best-amount grain-ahead
  set heading 90
  if (grain-ahead > best-amount)
    [ set best-direction 90
      set best-amount grain-ahead ]
  set heading 180
  if (grain-ahead > best-amount)
    [ set best-direction 180
      set best-amount grain-ahead ]
  set heading 270
  if (grain-ahead > best-amount)
    [ set best-direction 270
      set best-amount grain-ahead ]
  set heading best-direction
end

to-report grain-ahead  ;; procedura elv
  let total 0
  let how-far 1
  repeat vision
    [ set total total + [grain-here] of patch-ahead how-far
      set how-far how-far + 1 ]
  report total
end

to grow-grain  ;; procedura polek
  ;; pokud na polku nen maximln mon mnostv zrn, pak procedura 
  ;; pid mnostv zrn, odpovdajc hodnot parametru kolik-zrni-dorusta
  if (grain-here < max-grain-here)
    [ set grain-here grain-here + kolik-zrni-dorusta
      ;; pokud nov mnostv zrn na polku pekroilo maximln
      ;; kapacitu, srovnej toto mnostv na maximum
      if (grain-here > max-grain-here)
        [ set grain-here max-grain-here ]
      recolor-patch ]
end

;; kad elva sklz zrn na svm polku. Poud je jich na jednom
;; polku vce, rozdluje se mezi n zrn rovnomrn
to harvest
  ; elvy rovnomrn sklz zrn, dokud nen vyerpno
  ask turtles
    [ set wealth floor (wealth + (grain-here / (count turtles-here))) ]
  ;; elvy postupn sklid vechno zrn z danho polka, kter podle toho zmn barvu
  ask turtles
    [ set grain-here 0
      recolor-patch ]
end

to move-eat-age-die  ;; procedura elv
  fd 1
  ;; spotebuj zrn mrn svmu metabolismu
  set wealth (wealth - metabolism)
  ;; zestrni o asovou jednotku
  set age (age + 1)
  ;; zkontroluj podmnky smrti: pokud nem dn zrn
  ;; nebo jsi star ne je oekvan doba ivota, pak
  ;; zeme a jsi znovu narozen s novmi nhodnmi 
  ;; hodnotami promnnch
  if (wealth < 0) or (age >= life-expectancy)
    [ set-initial-turtle-vars ]
end

;;;
;;; Procedury grafu
;;;

to setup-plots
  set-current-plot "Vvoj td"
  set-plot-y-range 0 pocet-lidi
  set-current-plot "Histogram td"
  set-plot-y-range 0 pocet-lidi
end

to update-plots
  update-class-plot
  update-class-histogram
  update-lorenz-and-gini-plots
end

;; vytvo rov graf, ukazujc poet lid v jednotlivch tdch (podle bohatstv)
to update-class-plot
  set-current-plot "Vvoj td"
  set-current-plot-pen "chud"
  plot count turtles with [color = red]
  set-current-plot-pen "stedn"
  plot count turtles with [color = green]
  set-current-plot-pen "bohat"
  plot count turtles with [color = blue]
end

;; ;; vytvo histogram, ukazujc poet lid v jednotlivch tdch (podle bohatstv)
to update-class-histogram
  set-current-plot "Histogram td"
  plot-pen-reset
  set-plot-pen-color red
  plot count turtles with [color = red]
  set-plot-pen-color green
  plot count turtles with [color = green]
  set-plot-pen-color blue
  plot count turtles with [color = blue]
end

to update-lorenz-and-gini-plots
  set-current-plot "Lorenzova kivka"
  clear-plot

  ;; nakresl diagonlu z levho dolnho rohu do pravho hornho
  set-current-plot-pen "diag"
  plot 0
  plot 100

  set-current-plot-pen "Lorenz"
  set-plot-pen-interval 100 / pocet-lidi
  plot 0

  let sorted-wealths sort [wealth] of turtles
  let total-wealth sum sorted-wealths
  let wealth-sum-so-far 0
  let index 0
  let gini-index-reserve 0

  ;; dle bude sestrojena Lorenzova kivka a zrove
  ;; je vypotn Giniho index
  repeat pocet-lidi [
    set wealth-sum-so-far (wealth-sum-so-far + item index sorted-wealths)
    plot (wealth-sum-so-far / total-wealth) * 100
    set index (index + 1)
    set gini-index-reserve
      gini-index-reserve +
      (index / pocet-lidi) -
      (wealth-sum-so-far / total-wealth)
  ]

  ;; vykresl Giniho index v grafu
  set-current-plot "Giniho index"
  plot (gini-index-reserve / pocet-lidi) / area-of-equality-triangle
end

to-report area-of-equality-triangle
  ;; tento vpoet nen nutn, pokud m promnn pocet-lidi vysokou 
  ;; hodnotu -- pro tuto vysokou hodnotu meme pout piblin odhad 0.5
  report (pocet-lidi * (pocet-lidi - 1) / 2) / (pocet-lidi ^ 2)
end


; *** NetLogo 4.0.2 Model Copyright Notice ***
;
; This model was created as part of the project: CONNECTED MATHEMATICS:
; MAKING SENSE OF COMPLEX PHENOMENA THROUGH BUILDING OBJECT-BASED PARALLEL
; MODELS (OBPML).  The project gratefully acknowledges the support of the
; National Science Foundation (Applications of Advanced Technologies
; Program) -- grant numbers RED #9552950 and REC #9632612.
;
; Copyright 1998 by Uri Wilensky.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; This model was converted to NetLogo as part of the projects:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING
; IN CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT.
; The project gratefully acknowledges the support of the
; National Science Foundation (REPP & ROLE programs) --
; grant numbers REC #9814682 and REC-0126227.
; Converted from StarLogoT to NetLogo, 2001.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (1998).  NetLogo Wealth Distribution model.
; http://ccl.northwestern.edu/netlogo/models/WealthDistribution.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 1998 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/WealthDistribution
; for terms of use.
;
; *** End of NetLogo 4.0.2 Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
184
10
602
449
25
25
8.0
1
10
1
1
1
0
1
1
1
-25
25
-25
25
1
1
1
ticks

CC-WINDOW
5
648
917
743
Command Center
0

BUTTON
8
256
79
289
Piprav
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
108
256
175
289
Start
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
8
72
176
105
max-videni
max-videni
1
15
5
1
1
NIL
HORIZONTAL

SLIDER
8
301
176
334
interval-rustu-zrni
interval-rustu-zrni
1
10
1
1
1
NIL
HORIZONTAL

SLIDER
8
106
176
139
metabolismus-max
metabolismus-max
1
25
15
1
1
NIL
HORIZONTAL

SLIDER
8
38
176
71
pocet-lidi
pocet-lidi
2
1000
250
1
1
NIL
HORIZONTAL

SLIDER
8
208
176
241
procento-nejlepsi-pudy
procento-nejlepsi-pudy
5
25
10
1
1
%
HORIZONTAL

SLIDER
8
174
176
207
delka-zivota-max
delka-zivota-max
1
100
83
1
1
NIL
HORIZONTAL

PLOT
3
454
255
634
Vvoj td
as
Poet lid
0.0
50.0
0.0
250.0
true
true
PENS
"chud" 1.0 0 -2674135 true
"stedn" 1.0 0 -10899396 true
"bohat" 1.0 0 -13345367 true

SLIDER
8
335
176
368
kolik-zrni-dorusta
kolik-zrni-dorusta
1
10
4
1
1
NIL
HORIZONTAL

SLIDER
8
140
176
173
delka-zivota-min
delka-zivota-min
1
100
1
1
1
NIL
HORIZONTAL

PLOT
257
454
469
634
Histogram td
Tdy
Poet lid
0.0
3.0
0.0
250.0
false
false
PENS
"default" 1.0 1 -2674135 true

PLOT
471
454
687
634
Lorenzova kivka
Populace %
Bohatstv %
0.0
100.0
0.0
100.0
false
true
PENS
"Lorenz" 1.0 0 -2674135 true
"diag" 100.0 0 -16777216 true

PLOT
689
454
908
634
Giniho index
as
Giniho index
0.0
50.0
0.0
1.0
true
false
PENS
"default" 1.0 0 -13345367 true

@#$#@#$#@
CO JE TO?
---------
Tento model simuluje rozdlen bohatstv ve spolenosti. Znm ren "Bohat bohatnou a chud chudnou." ilustruje nerovnomrnost rozdlen bohatstv. Model produkuje rozdlen bohatstv, kter odpovd tzv. Paretovu zkonu. Tento zkon popisuje empiricky ovitelnou skutenost, e v prmru okolo 20 % lid vlastn 80 % veho bohatstv. Agenti v modelu jsou rozdleni do t td podle bohatstv. Existuje zde velk mnostv ervench "chudch agent", mn je zelench "stedn tda" a jet mnohem mn modrch "bohatch" agent. Kad lovk z chud tdy vlastn 0 a 1/3 maximlnho bohatstv (maximln bohatstv je bohatstv nejbohatho lovka v danm kole), lovk ze stedn tdy vlastn 1/3 a 2/3 maximlnho bohatstv a bohat lovk vlastn 2/3 a maximum z maximlnho bohatstv. 

JAK TO FUNGUJE?
---------------
Tento model je adaptac pvodnho modelu Epsteina a Axtella "Sugarscape". Msto metafory cukru, kter pouval pvodn model, pouvme zde metaforu zrn. Na kadm polku roste jist mnostv zrn a je stanoveno, kolik zrn na kterm polku me maximln vyrst. Lid sbraj zrn z polek a jed ho, aby peili. Mnostv nastdanho zrn pedstavuje bohatstv. 

Na zatku maj lid zhruba stejn bohatstv. Lid mohou chodit po krajin a sbrat tolik zrn kolik chtj. Kad lovk se pohne tm smrem, kde le nejvce zrn. Lid se ale li v tom, jak daleko (kolik polek) vid, tedy i ve svch schopnostech zjistit celkov mnostv zrn ve vt vzdlenosti. V kadm kole mus snst kad lovk jistou st svho zrn. Toto mnostv pedstavuje nronost jejich metabolismu a me se u rznch lid liit. Lid tak maj omezenou dobu ivota. Kdy se lovku doba jeho ivota napln nebo mu dojde zrn, tak zeme. Msto nj se objev nov agent s nhodnm metabolismem a mnostvm zrn. Neexistuje zde ddinost, nov agent nedd po svm pedchdci jeho bohatstv. 

Pro pozorovn mry nerovnomrnosti v rozdlen bohatstv pouvme graf, kter se nazv Lorenzova kivka. Na ose x setdme populaci zleva doprava podle bohatstv, a pot vyneseme postupn natan celkov bohatstv (od nejchudch k nejbohatm) na osu y. Tak meme vidt kolik procent bohatstv vlastn jist procento populace. Rozsah hodnot na obou osch je tedy 0 % a 100 %.

Jin zpsob, jak porozumt Lorenzov kivce, je pedstavit si, e ve spolenosti 100 lid je k dispozici 100 dolar. Kad lovk pedstavuje 1 % populace a kad dolar 1 % bohatstv. Seadme lidi podle jejich bohatstv od nejchudch k nejbohatm na ose x. Na osu vyneseme vdy souet bohatstv pslunho lovka a bohatstv vech lid chudch ne on. Napklad njak lovk X, kter je dvact nejchud ze sta, stoj na ose x na dvactm mst zleva a na ose y mu pslu hodnota rovn potu dolar, kter vlastn tento lovk a vichni lid chud ne on dohromady. Tato hodnota pedstavuje procento bohatstv, kter vlastn nejchudch 20 % populace.
Kdyby Lorenzova kivka byla pm diagonln linie se sklonem 45 stup (mla by smrnici 1), tak by bylo bohatstv populace rozdleno zcela rovnomrn, kad by vlastnil jeden dolar. Naopak pokud by pouze jeden lovk vlastnil vechno bohatstv, Lorenzova kivka by vypadala jako obrcen "L". Tedy 99 % lid nevlastn ani jeden dolar a posledn nejbohat st lovk m vech 100 dolar. V praxi se Lorenzova kivka nachz nkde mezi diagonlou a obrcenm "L" .   

Z Lorenzovy kivky meme odvodit tzv. Giniho index (nebo Giniho koeficient), kter je selnou mrou nerovnomrnosti rozdlen bohatstv. Giniho index je podl plochy mezi Lorenzovou kivkou a diagonlou a celkov plochy pod diagonlou (co je vdy 0.5 - plocha pravohlho trojhelnku s odvsnami dlky 1). Kdyby Lorenzova kivka byla diagonln linie pod hlem 45 stup, byl by Giniho index 0. Kdyby Lorenzova kivka vypadala jako obrcen "L", byl by Giniho index 1. Tedy Giniho index je pmo mrn  nerovnomrnosti rozdlen bohatstv a pohybuje se v rozmez 0 a 1.

JAK MODEL OVLDAT?
------------------
PIPRAV nhodn ur kolik zrn bude kde rst a rozmst lidi s nhodn nastavenm bohatstvm a metabolismem. START zahajuje a ukonuje simulaci. 

Nastaven PROCENTO-NEJLEPSI-PUDY uruje poten hustotu polek, na kterch poroste maximln mnostv zrn. INTERVAL-RUSTU-ZRNI nastavuje, jak asto bude zrn dorstat, KOLIK-ZRNI-DORUSTA nastavuje kolik zrn v tomto intervalu doroste.

POCET-LIDI nastavuje poten poet lid. DOBA-ZIVOTA-MIN je minimln poet kol, po kterch me lovk umt stm (ale me umt i dve pokud mu dojde zrn). DOBA-ZIVOTA-MAX je maximln poet kol, po kterch lovk umr stm. METABOLISMUS-MAX nastavuje maximln objem zrn, kter mus lovk v kadm kole snst, aby peil . VIDENI-MAX nastavuje maximln vzdlenost (poet polek), do kter me lovk vidt. 

Graf VVOJ TD ukazuje vvoj potu lid v jednotlivch tdch v ase. HISTOGRAM TD ukazuje rozdlen do td v aktulnm kole. LORENZOVA KIVKA ukazuje Lorenzovu kivku v aktulnm kole a tak diagonln linii se sklonem 45 stup. GINIHO INDEX ukazuje vvoj Giniho indexu v ase. Lorenzova kivka a Giniho index jsou aktualizovny pouze kadch pt kol (kvli vpoetn nronosti). 

VIMNTE SI
-----------
Vimnte si rozdlen bohatstv ve tdch. Jsou tdy stejn poetn? 

Model ukazuje platnost Paretova zkona, kter tvrd, e men st populace vlastn vt st bohatstv. Pro k tomu dochz? 

Mohou lid v modelu zmnit svoji tdu (zbohatnout, zchudnout)?

Za jak dlouho doshnou poty pslunk jednotlivch td stabilnch hodnot?

Mn se njak rozdlen bohatstv v delm ase? (Rada: sledujte vvoj Giniho indexu. Stabilizuje se na urit hodnot nebo osciluje?)

Zkuste najt na internetu informace o Giniho indexu jednotlivch zem, nap. esk republiky. Odpovd i neodpovd modelov Giniho index skutenm indexm? Pro?
(Viz nap. http://en.wikipedia.org/wiki/Gini_index#Income_Gini_indices_in_the_world)


ZKUSTE SI
---------
Jak se mn Giniho index pro jednotliv nastaven? 

Zstv pro nkter nastaven zachovna vcemn stejn hodnota Giniho indexu pro irokou klu rznch hodnot (chovn modelu je tzv. robustn)?

Existuj nastaven, pro kter se model nechov podle Paretova zkona?

ROZEN MODELU
----------------
Zkuste na zatku umstit vechny lidi na jedno polko. Co se stane?

Zkuste nastavit vem lidem pi narozen stejn bohatstv nebo maximln vidn. Dojde i tak po njak dob k nerovnomrnmu rozloen bohatstv? Bude se njak liit Giniho index pro nhodn a pro stejn nastaven tchto parametr?

Nechte kadho novho lovka zddit st bohatstv umrajcho lovka. 

Umonte, aby nashromdn zrn dvalo svmu vlastnkovi njakou vhodu i nevhodu (nap. zlepen vidn nebo naopak zpomalen).

Bude se model chovat stejn, pokud by byla rodnost pdy piazena polkm zcela nhodn a ne v gradientech? Zkuste pidat rzn typy krajin a kad piate zvltn tlatko PIPRAV. 

Umonte navrhnte? njak zpsob ddinosti metabolismu i vidn. Dojde k evoluci, ve kter budou pevat ti nejlpe "pizpsoben"?
Zkuste do modelu pidat seznn zmny. Nap. v jistch stech krajiny me rst zrn lpe v jistch asovch secch. 

Dokete zmnit model tak, aby lid dosahovali rovnomrnho rozdlen bohatstv?

Zpsob, jakm je napsn kd programu modelu (procedures), zapiiuje, e lid se budou obas nsledovat. To je obzvlt zeteln, kdy nastavte poet lid relativn nzk, nap. mezi 50 a 100, a nastavte vysokou maximln dlku ivota. Pro dochz k tomuto jevu? (Rada: Kdy a jak probh rozhodovn, kam se m lovk vydat?)
Zkuste zmnit kd programu tak, aby k tomuto jevu nedochzelo. Zmn se chovn modelu?

PROGRAMOVAC ZAJMAVOSTI NETLOGA
--------------------------------
K obarven polek je pouit reporter "scale-color". Barva polek je klovna podle jeho hodnoty.

Vimnte si pouit seznam (lists) pi vykreslovn Lorenzovy kivky a vpotu Giniho indexu. 

PODKOVN A ODKAZY
-------------------
Pro vysvtlen Paretova zkona viz http://www.xrefer.com/entry/445978.

Tento model je zaloen na modelu popsanm v  Epstein, J. & Axtell R. (1996). Growing Artificial Societies: Social Science from the Bottom Up. Washington, DC: Brookings Institution Press.
 
Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz:   Wilensky, U. (1998).  NetLogo Wealth Distribution model.  http://ccl.northwestern.edu/netlogo/models/WealthDistribution.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch, uvete prosm tyto informace:  Copyright 1998 Uri Wilensky.  All rights reserved.  See http://ccl.northwestern.edu/netlogo/models/WealthDistribution for terms of use.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 30 225
Line -7500403 true 150 150 270 225

@#$#@#$#@
